/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 6 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file include SST ATP functions
   *
   *  \version SST_SEP_ATP_Utils.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include <stdio.h>
#include "SST_SEP_TST.h"
#include "CRYS_SST.h" 
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_DataOpTestDataStruct* TST_ATP_DataOpTestData;
/******************  Defines  ***********************************/
#define UTIL_DATA_SIZE 3
/****************************************************************
* Function Name:
* SEPQA_SST_Utility_Handle
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the handle build and handle type retrieval
*
* Algorithm:
* 1.  Create a new session by calling SST_SessionCreate.
* 2.  Open a transaction by calling SST_TransactionStart.
* 3.  Insert a new data object by calling SST_InsertData with a user defined handle.
* 4.  Build a handle by calling SST_DataHandleBuild
* 5.  Read a data object using this handle by calling SST_DataRead.
* 6.  Validate this is the same data by comparing the retrieved data with the inserted data
* 7.  Validate the handle type by calling SST_DataTypeGet.
* 8.  Delete the data by calling SST_DeleteData.
* 9.  Close the transaction by calling SST_TransactionClose.
* 10. Delete the session by calling SST_SessionDelete.
********************************************************************************/
DxError_t SEPQA_SST_Utility_Handle ( void )
{
    /********* TST Variables initialization *********/
    SSTTxnId_t         TST_TransactionId;
    SSTSessionId_t     TST_SessionId;
    SSTDataType_t      TST_aDataType;
    SSTDataType_t      TST_aDataTypeOut;
    SSTObjectId_t      TST_aDataObjID;
    SSTHandle_t        TST_aDataHandle,TST_AuthDefaultHandle;
    SSTHandle_t        TST_BuiltaDataHandle;
    DxByte_t           TST_Data[] = {0x01,0x02,0x03};
    DxByte_t           TST_DataOut[UTIL_DATA_SIZE];
    DxUint32_t         TST_DataSize = UTIL_DATA_SIZE;
    SSTHandle_t        TST_AuthHandle;
    DxChar             * TestName = "ATP test SST Utility Handle";
    DxError_t       TST_Status = DX_FAILURE;

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ********** SST_TST_ATP_UtilityHandle Tests *********** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    TST_aDataType = 0x33;
    TST_aDataObjID = TST_aDataHandle.objId = 0x4455;
    TST_AuthHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_AuthHandle.objDigest = 0x0;

    
    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                                          TestName,
                                          TestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                          TestName,
                                          TestName);

    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                 TST_SessionId,
                                                 TST_ATP_DataOpTestData[0].TST_Password,
                                                 TST_ATP_DataOpTestData[0].TST_PasswordSizeInBytes,
                                                 TST_ATP_DataOpTestData[0].TST_MaxNumOfTrials,
                                                 TST_AuthDefaultHandle,
                                                 &TST_AuthHandle,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               TestName,
                               TestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);


    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_DataOpTestData[0].TST_Password,
                                        TST_ATP_DataOpTestData[0].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Password",
                               TestName,
                               TestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_TransactionStart",
                               TestName,
                               TestName);


    /* Insert a new Data object */
    /*--------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_AuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               TST_aDataType,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                                          TestName,
                                          TestName);


    /*Build a handle*/
    /*--------------*/
    TST_Status = SST_DataHandleBuild(TST_aDataType,TST_aDataObjID,&TST_BuiltaDataHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataHandleBuild",
                                          TestName,
                                          TestName);

   
   /* Read the data */
   /*---------------*/
    TST_Status = SST_DataRead(TST_SessionId,
                             TST_BuiltaDataHandle,
                             0,
                             TST_DataOut,
                             &TST_DataSize,
                             TST_Workspace,
                             TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                                          TestName,
                                          TestName);

   
    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_Data,TST_DataOut,TST_DataSize))
          TST_Status = TESTPASS; /*Data Buffers are the same*/
     else
           TST_Status = TESTFAIL; /*Data Buffers are different*/
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                                          TestName,
                                          TestName);


    /*Validate the handle type*/
    /*------------------------*/
    TST_Status = SST_DataTypeGet(TST_aDataHandle,&TST_aDataTypeOut);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataTypeGet",
                                          TestName,
                                          TestName);


    if(TST_aDataTypeOut != TST_aDataType)
      TST_Status = TESTFAIL;
    else
      TST_Status = TESTPASS;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_aDataTypeOut",
                                          TestName,
                                          TestName);


    /*Delete the data*/
    /*---------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                                          TestName,
                                          TestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                   DX_TRUE,/*reflash sensitive*/
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                          TestName,
                                          TestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                                          TestName,
                                          TestName);





   EXIT_ON_ERROR:
   return TST_Status;

}
/****************************************************************
* Function Name:
*  SEPQA_SST_Utility_Size
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the handle build and handle type retrieval
*
* Algorithm:
* 1.  Call SST_UtilNVSSizesGet with the MainDB handle.
* 2   Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle.
* 3.  Create a session for operations.
* 4.  Open a transaction by calling SST_TransactionStart.
* 5. Call SST_DataInsert with data element again.
* 6. Modify the data.
* 7. Call Transaction Rollback.
* 8. Open a transaction for operations.
* 9. Insert a new Data object.
* 10. Delete the data.
* 11. insert 6 data objects the 6 should fail.
* 12. Delete the data objects.
* 13. Insert 5 data objects.
* 14. Delete the data objects.
* 15. Set the max Size of both DB to 0x7ffffff0
* 16. Close the transaction.
* 17. Delete the session.
********************************************************************************/
DxError_t SEPQA_SST_Utility_Size ( void )
{
    ///********* TST Variables initialization *********/
    SSTTxnId_t         TST_TransactionId;
    SSTSessionId_t     TST_SessionId;
    SSTDataType_t      TST_aDataType;
    SSTHandle_t        TST_aDataHandle;
    DxByte_t           TST_Data[20]; 
    DxUint32_t         TST_DataSize = 20;
    SSTHandle_t        TST_AuthHandle,TST_AuthDefaultHandle;
    DxUint32_t         i;
    DxChar             *TestName = "ATP test SST Utility Size";  
    DxError_t          TST_Status = DX_FAILURE;
    DxUint32_t         dataSize = 256;

    TST_aDataType = 0x33;
    TST_aDataHandle.objId = 0x4455;
    TST_AuthHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_AuthHandle.objDigest = 0x0;


    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," *********** SST_TST_ATP_UtilitySize Tests ************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));




    /* 3.Create a session for operations */
    /*-----------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"3.  SST_SessionCreate",
                                          TestName,
                                          TestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_TransactionStart",
                               TestName,
                               TestName);
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                 TST_SessionId,
                                                 TST_ATP_DataOpTestData[0].TST_Password,
                                                 TST_ATP_DataOpTestData[0].TST_PasswordSizeInBytes,
                                                 TST_ATP_DataOpTestData[0].TST_MaxNumOfTrials,
                                                 TST_AuthDefaultHandle,
                                                 &TST_AuthHandle,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               TestName,
                               TestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);


    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_DataOpTestData[0].TST_Password,
                                        TST_ATP_DataOpTestData[0].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                               TestName,
                               TestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_TransactionStart",
                               TestName,
                               TestName);
  TST_DataSize = 2;
    /*6.Call SST_DataInsert with data element again*/
    /*----------------------------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_AuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               TST_aDataType,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"6. SST_DataInsert Call SST_DataInsert with data element size 2 ",
                                          TestName,
                                          TestName);


    /*7. Modify the data*/
    /*-------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Data,
                               TST_DataSize,
                               TST_DataSize - 1,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"7. SST_DataModify",
                                          TestName,
                                          TestName);



    /*8 Call Transaction Rollback*/
    /*----------------------------*/
    TST_Status = SST_TransactionRollback(TST_TransactionId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"8. SST_TransactionRollback",
                                          TestName,
                                          TestName);
 


    /*.9 Open a transaction for operations */
    /*-------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"9. SST_TransactionStart",
                                          TestName,
                                          TestName);


    /*10. Insert a new Data object */
    /*-----------------------------*/
     TST_Status = SST_DataInsert(TST_TransactionId,
                                 TST_SessionId,
                                 TST_AuthHandle,
                                 TST_Data,
                                 TST_DataSize,
                                 DX_TRUE,
                                 TST_aDataType,
                                 &TST_aDataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"10. SST_DataInsert",
                                          TestName,
                                          TestName);


    /*11 Delete the data*/
    /*-----------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11. SST_DataDelete",
                                          TestName,
                                          TestName);




   /*12.insert 6 data objects the 6 should fail*/
   /*------------------------------------------*/                          
    dataSize = 16;
   for(i = 0; i< 5 ; i++)
   {
    TST_aDataHandle.objId = i;

    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_AuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               0,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12. SST_DataInsert",
                                          TestName,
                                          TestName);

   }

   /*14.delete the data objects*/
   /*--------------------------*/
   for(i = 0; i< 5 ; i++)
   {
     TST_aDataHandle.objId = i;

    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_aDataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"14. SST_DataDelete",
                                          TestName,
                                          TestName);


   }


   /*15.insert 5 data objects*/
   /*------------------------*/
   for(i = 0; i< 5 ; i++)
   {
    TST_aDataHandle.objId = i;
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_AuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               0,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"15. SST_DataInsert",
                                          TestName,
                                          TestName);

   }


   /*16.delete the data objects*/
   /*--------------------------*/
   for(i = 0; i< 5 ; i++)
   {
       TST_aDataHandle.objId = i;

       TST_Status = SST_DataDelete(TST_TransactionId,
                                 TST_SessionId,
                                 TST_aDataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"16. SST_DataDelete",
                                             TestName,
                                             TestName);

   }   




    /*32. Close the transaction */
    /*--------------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"17. SST_TransactionEnd",
                                          TestName,
                                          TestName);

    /* 18.Delete the session */
    /*-----------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"18. SST_SessionDelete",
                                          TestName,
                                          TestName);

   EXIT_ON_ERROR:
   return TST_Status;

}


